/*
	control.js
	JavaScript for Classic Memory
	Version 1.0 / august 2005
	
	Patrick Machielse (c) 2005
	Hieper Software
*/

//	----------------------------------------------------------------------
//	CONTROLS
//	----------------------------------------------------------------------

function makeBasic(obj) {		
	//	**	methods
	//	show / hide the control
	obj.show = function (yn) { this.style.display = yn ? "block" : "none"; };
}

function makeControl(image, action, highliteURL) {
	//	**	ivars
	image.normal = image.src;		//	the non highlited image
	image.hilite = highliteURL;		//	the image when the mouse is pressed
	image.action = action;			//	function exectuted on mouse click
	image.over	 = false;			//	mouse pointer is over control
	image.down	 = false;			//	mouse was pressed on control
	
	makeBasic(image);				//	add base controler functions
	
	//	**	initialisation (set up event handlers)
	image.onmouseover = function (event) {
		if ( event.button == 0 ) this.down = false;
		this.over = true;
		this.src  = this.down ? this.hilite : this.normal;
	}
	
	image.onmouseout = function (event) { 
		this.over = false;
		this.src  = this.normal;
	}
	
	image.onmousedown = function (event) {
		this.down = true;
		this.src  = this.hilite;
	}
	
	image.onmouseup = function (event) {
		this.down = false;
		this.src  = this.normal;
	}
	
	image.onclick = function (event) {
		if ( this.over && this.action ) this.action();
	}
}

function makeAnimated(image, imageURLs, interval) {
	//	**	ivars
	image.frames = imageURLs;			//	array of animation frames
	image.timer	 = null;				//	animation timer
	image.index	 = 0;					//	current index in frames array
	
	makeBasic(image);					//	add base controler functions

	//	**	methods
	//	start the animation
	image.start = function () {
		if ( !this.isAnimated() ) {
			var  self = this;
			this.style.display = "block";
			this.timer = setInterval(function () { self.animate(); }, interval);
		}
	}
	
	//	draw the animation
	image.animate = function () {
		this.src = this.frames[++this.index % this.frames.length];
	}
	
	//	stop the animation
	image.stop = function () {
		if ( this.isAnimated() ) {
			clearInterval(this.timer);
			this.timer = null;
			this.style.display = "none";
		}
	}
	
	//	is the image currently animated?
	image.isAnimated = function () { return this.timer != null; }
}